//
// Fusion-C
//
// Bomb Jack versión para MSX-1
// 
// Proyecto-aprendizaje del TFG
// EUI UPV 2020
//
// Frederic Garcia Nieto (2020)
//
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include "fusion-c/header/io.h"
#include "fusion-c/header/msx_fusion.h"
#include "fusion-c/header/vdp_sprites.h"
#include "fusion-c/header/psg.h"
#include "fusion-c/header/ayfx_player.h"
#include "Bombjack.h"

static FCB file;                        // Used by MSXDOS loading routines


/************ PROTOTIPO FUNCIONES ************************/

// carga de fondos y sprites
void loadSC2 (char *filename);
void mostrarSC2 (void);
void loadSprites (char *filename);
// salón de la fama
void crearHOF(t_HallOfFame * HallOfFame);
void loadHOF (char *filename);
void mostrarHOF (t_HallOfFame * HallOfFame, unsigned int MAX_score, unsigned int PL_score);
char entrarEnHOF (t_HallOfFame * HallOfFame);
void quicksort(t_HallOfFame * V, int len);
// menu
char menu (t_HallOfFame * HallOfFame, unsigned int MAX_score, unsigned int PL_score);
// niveles (carga)
void loadNivel(byte nivel);
void loadMap(char *filename, boolean pintar_plataformas);
char loadTracaBombas (byte nivel);
// bombas
void enciendeBomba (t_bomba *bomba);
void repintaFondo (byte fila, byte columna);
unsigned int recogeBomba (t_bomba *bomba);
// monedas
void crearMoneda (byte type);
void actualizaMoneda (t_Moneda *moneda, unsigned int frame);
void dibujaMoneda (byte moneda);
// enemigos
void creaEnemigoPrincipal (void);
void creaEnemigoSecundario (byte enemigo);
void actualizaEnemigos(t_Enemigo *enemigo, unsigned int frame, byte i);
boolean ordenaListaEnemigos (void);
void dibujaEnemigo(byte enemigo);
// avatar
void inicializaAvatar (void);
void actualizaAvatar (t_Entrada *entrada);
void dibujaAvatar(byte plano, byte patron, byte x, byte y);
void baileFinNivel (void);
// Interfaz de usuario
void mostrarGUI (unsigned int PlScore, byte vidas);
// letreros inicio y fin (start y game over)
void mostrarStart(void);
void mostrarLetreroGameOver (void);
// bonus
unsigned int bonus(byte nBombas, unsigned int PL_score, byte nivel);
// lógica
char procesarEntrada (t_Entrada *entrada);
boolean actualizaColisiones (void);
char FT_wait (int cicles);
char FT_RandomNumber (char a, char b);
void FT_errorHandler(char n, char *name);
void FT_SetName( FCB *p_fcb, const char *p_name );
// Música y FX
int FT_LoadData(char *file_name, char *buffer, int size, int skip);
void FT_CheckFX (void);
void SincronizaFX (char temp);
// salir
void salirMSXDOS (void);



/*******************************************************/

//---------------- MAIN -------------------------
void main(void) 
{
	t_HallOfFame HallOfFame[LongHOF];
	t_Entrada entrada;
	boolean endGame, gameOver;
	char salir = 0;
	unsigned int i, frame;
	byte timerEnemigos = 250;
	byte nBombasEncendidas;
	byte maxEnemigos = 4;
	afbdata=MMalloc(AFB_SIZE);	// FX
	

	/********** Inicialización ***********/

	// Sistema de audio
	KeySound(0);
	InitPSG();
  	InitFX();

	// Pantalla en modo grafico 2
	SetColors(1, 1, 1);		// pantalla en negro	
	Screen(2); // Modo 2 graficos de alta resolucion
	
	//--- Carga y visualización de la pantalla de carga
	loadSC2("loading.sc2");
	mostrarSC2();

	// Interfaz grafico
	gui.HiScore = 100;

	// Salón de la Fama inicial
	crearHOF(HallOfFame);

	// Efectos de sonido FX
  	FT_LoadData("FX.afb", afbdata, AFB_SIZE, 0);	

	// Sprites	
	SpriteReset();	// puesta a cero de todos los sprites
	Sprite16();		// tamaño de sprites 16x16
	SpriteSmall();	// tamaño de sprites sin ampliar
	loadSprites("sprites.dat");		
	

	/********** Bucle videojuego BOMB JACK ***********/
	while (salir == 0) {
	
		/********** Inicialización de la partida *********/
		gui.nivel = 0;
		endGame = false;
		gameOver = false;
		// Player (avatar)
		player.vidas = 3;
		player.PlScore = 0;
		player.inmunidad = false;

		/********** Bucle Menú inicio *********/
		loadSC2("menu.sc2");	// Leyendo pantalla del menu
		mostrarSC2();			// Mostrando la pantalla de menu
		// Pulsar la tecla 'ESC' y el disparo para salir del videojuego
		salir = menu(HallOfFame, gui.HiScore, gui.HiScore);	
		if (salir == 27) { // tecla Escape
			salirMSXDOS();
		} else {
			salir = 0;
			KillKeyBuffer();
		}

		/********** Bucle de la partida *********/
		while (salir == 0 && !gameOver && !endGame && Inkey() != 27) {

			//--- INICIALIZACIÓN DEL NIVEL ---
			SpriteOff();
			// Inicialización de variables
			nBombasEncendidas = 0;
			nextBomba = 0;
			nPajaros = 0;
			nEnemigos = 0;
			nMonedas = 0;
			nMonedasORO = 0;
			gui.multiplicador = 1;
			gui.barraEnergia = 0;
			gui.scoreLevel = 0;
			// Curva de dificultad (Nº máx. de enemigos en pantalla, velocidad e inicialización de temporizadores)
			switch (gui.nivel) {
				case 0: 
					maxEnemigos = 4;
					break;
				case 10: 
					maxEnemigos = 5;
					break;
				case 20: 
					maxEnemigos = 6;
					timerEnemigos = 200;	// 4 segundos
					break;
				case 30: 
					maxEnemigos = MAX_ENEMIGOS;
					velocidad++;	// aumenta la velocidad de los enemigos
					break;
				case 40: 
					timerEnemigos = 150;	// 3 segundos
					break;
				case 50: 
					velocidad++;	// aumenta la velocidad de los enemigos
					break;
			}

			// Inicialización del Avatar			
			inicializaAvatar();
			// Inicialización bandera reordenar lista de enemigos
			reordenarListaEnemigos = false;
			// Carga del nivel
			loadNivel(gui.nivel);
			mostrarGUI (player.PlScore, player.vidas);
			// Activación de los sprites
			SpriteOn();						
			Screen(2);	// limpiado de la pantalla
			mostrarSC2();
			// Animación letrero 'START!'
			mostrarStart();
			// Inicialización de contador de iteraciones
			frame = 0;
			// Lanzamiento del Temporizador
			SetRealTimer(0);

 			/************ MIENTRAS NO FIN NIVEL ****************/
			while ((player.bombas != MAX_BOMBAS) && !salir && !gameOver) {

				//--- CAPTURAR ENTRADA JUGADOR ---
				salir = procesarEntrada(&entrada);
				// Abortando la partida (tecla 'ESC')
				if (salir == 27) {					
					salir = 1;
					break;
				} else {
					salir = 0;
					KillKeyBuffer();
				}

				//--- ACTUALIZACIÓN DEL AVATAR/Jack ---
				actualizaAvatar(&entrada);
				
				//--- ACTUALIZACIÓN DE TIEMPOS (ENEMIGOS Y MONEDAS) ---
				// Creacion enemigos
				if (!nMonedasORO && nEnemigos<maxEnemigos && (frame % timerEnemigos == 0)) 
					creaEnemigoPrincipal ();

				// Creación monedas
				if (frame % 25 == 0 && nMonedas<MAX_MONEDAS) {
					// POWER
					if (gui.barraEnergia > 4) {	// barra de energia en su valor máximo				
						crearMoneda (P);
						gui.barraEnergia = 0;
						pintafondo = true;
						PlayFX(2);	// FX aparición moneda	
					} 
					// BONUS
					if ((gui.multiplicador < 5) && (frame % Timer_monedaNueva == 0)) {
						crearMoneda (B);
						PlayFX(6);	// FX aparición moneda
					} 
					// EXTRA (si Jack mata a todos los enemigos -> vida extra)
					if (player.enemigos == maxEnemigos) {
						crearMoneda (E);
						PlayFX(4);
					}
					// SPECIAL
					if (frame % 51 == 0 && RealTimer() % (Timer_monedaNueva*FT_RandomNumber(5,9)) == 8) {
						crearMoneda (S);
						PlayFX(6);	// FX aparición moneda 
					}
				}

				//--- IA Y SIMULACIÓN FÍSICA (ENEMIGOS Y MONEDAS) ---
				// enemigos
				if ((frame % 4) == 0)		
					for (i=0; i<nEnemigos; i++)
						actualizaEnemigos(&listaEnemigos[i], frame, i);
				// monedas
				if (nMonedas>0 && frame % 2 != 0)
					for (i=0; i<MAX_MONEDAS; i++) 
						actualizaMoneda (&listaMonedas[i], frame);

				//--- DETECCIÓN DE COLISIONES ---
				gameOver = actualizaColisiones();
				if (reordenarListaEnemigos) reordenarListaEnemigos = ordenaListaEnemigos();

				//--- ACTUALIZACIÓN DEL HI-SCORE (GUI)				
				if (gui.scoreLevel > gui.HiScore) gui.HiScore = gui.scoreLevel;
			
				//---- RENDERIZA LA PANTALLA ---			
				// pinta avatar
				dibujaAvatar(0, player.spriteActual, player.x, player.y);
				// pinta enemigos en los frames pares
				if (nEnemigos>0 && frame % 2 == 0)
					for (i=0; i<nEnemigos; i++) dibujaEnemigo(i);
				// pinta monedas en los frames impares
				if (nMonedas>0 && frame % 2 != 0)
					for (i=0; i<MAX_MONEDAS; i++) dibujaMoneda(i);
				// pinta fondo si hay que actualizarlo
				if (pintafondo) { // ha habido modificación del fondo o GUI
					// actualización de la puntación máxima (Hi-Scrore)
					if (player.PlScore+gui.scoreLevel < UINT_MAX && player.PlScore+gui.scoreLevel > gui.HiScore) 
						gui.HiScore = player.PlScore+gui.scoreLevel;						
					mostrarGUI (player.PlScore+gui.scoreLevel, player.vidas);
					CopyRamToVram (&tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);
					pintafondo = false;
				}

				//--- REALIMENTACIÓN SENSORIAL (actualización de FX y Música) ---
				FT_CheckFX();
		
				// Actualización del contador de iteración del bucle
				if (frame<UINT_MAX) frame++; else frame = 0;

			} // Fin nivel			

			SilencePSG();

			if (!salir) {
				// actualización de la puntuación según el multiplicador
				if ((gui.multiplicador * gui.scoreLevel + player.PlScore) < UINT_MAX)
					player.PlScore += (gui.multiplicador * gui.scoreLevel);
				mostrarGUI(player.PlScore, player.vidas);
				// pinta fondo
				CopyRamToVram (&tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);

				// Baile consecución del nivel
				if (player.bombas == MAX_BOMBAS) baileFinNivel(); 

				// ------------- bonus --------------
				for (i=0; i<MAX_BOMBAS; i++)
					if (lista_bombas[i].recogida && lista_bombas[i].encendida) nBombasEncendidas++;
				if (nBombasEncendidas>19) {
					loadSC2("Bonus.sc2");	// Cargando la pantalla de Bonus
					SpriteOff();			// Ocultando sprites
					Screen(2);				// inicializando pantalla
					mostrarSC2();			// Mostrando la pantalla de Bonus
					player.PlScore = bonus(nBombasEncendidas, player.PlScore, gui.nivel+1);
				}
				// actualización de la puntación máxima (Hi-Scrore)
				if (player.PlScore > gui.HiScore) gui.HiScore = player.PlScore;

				//--- comprobación de finalización de la partida ---
				if (gui.nivel < MAX_NIVELES-1) gui.nivel++;	// avance de nivel
				else endGame = true;
			}

			// inicialización de las monedas
			for (i=0; i<MAX_MONEDAS; i++) {	// reinicializando lista monedas
				listaMonedas[i].activa = false;
				listaMonedas[i].y = 209; 		// ocultación del sprite en pantalla
				listaMonedas[i].x = -32; 		// ocultación del sprite en pantalla
				PutSprite (listaMonedas[i].plano, listaMonedas[i].spriteActual, listaMonedas[i].x,listaMonedas[i].y, listaMonedas[i].color);
			}
			SpriteOff();

		} // !gameOver && !endGame

		/*********** CIERRE Y FINALIZACIÓN DE LA PARTIDA **********/
		// Fracaso (Game over)
		if (gameOver) {
			mostrarLetreroGameOver();
			// FX fin de partida
			PlayFX(7);
			SincronizaFX (100);
		} else if (endGame) {  
			// Éxito (Juego completado)
			loadSC2("final.sc2");
			SpriteOff();			// Ocultando sprites
			Screen(2);				// inicializando pantalla			
			mostrarSC2();
			while (!TriggerRead(0) && !TriggerRead(1) && !TriggerRead(2)) {;}
		}				

		// Comprobación si se entra en el salón de la fama
		if (player.PlScore >= HallOfFame[LongHOF-1].puntos) {
			entrarEnHOF(HallOfFame);		
			FT_wait(120); 	// esperamos unos segundos
		}

		// partida abortada
		if (salir == 1) salir = 0;

		SpriteOff();			// Ocultando sprites
		Screen(2);				// inicializando pantalla	
	} // Menu

} // main

//---------- CARGA DE FONDOS Y SPRITES -----------------//

//---------- Leer ficheros en SC2 ---------
void loadSC2 (char *filename) {
	int file;	// Set a file handler variable

	file=Open(filename, O_RDONLY);
	// Leyendo la tabla de patrones	
	Read(file, tablaPatrones, TAM_TablaPatrones);
	// Leyendo la tabla de nombres
	Read(file, tablaNombres, TAM_TablaNombres);
	// Leyendo la tabla de colores
	Read(file, tablaColor, TAM_TablaColor);
	Close(file);
}

//----------- Mostrar imagenes en SC2 ------------
void mostrarSC2 (void) {
	HideDisplay();
	// Tablas patrones, nombre (mapa) y color
	CopyRamToVram (&tablaPatrones[0], dirBaseTablaPatrones, TAM_TablaPatrones);
	CopyRamToVram (&tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);
	CopyRamToVram (&tablaColor[0], dirBaseTablaColor, TAM_TablaColor);	
	ShowDisplay();
}

// ------- lectura del fichero de sprites ----
void loadSprites (char *filename) {	
	int file;	// Set a file handler variable
	
	file=Open(filename, O_RDONLY);
	// Leyendo la tabla de patrones	de sprites
	// Reutilización de la tablaPatrones como buffer 
	Read(file, tablaPatrones, TAM_SpritesPatrones);
	// Copiando los sprites del buffer a la Tabla de patrones de sprites del VDP
	CopyRamToVram (&tablaPatrones[0], dirBaseTablaSpritesPatrones, TAM_SpritesPatrones);
	// Liberamos recursos
	Close(file);
}


//---------- SALÓN DE LA FAMA -----------------//

//-------- Creación del HOF de inicio -----------
void crearHOF (t_HallOfFame * HallOfFame) {
	
	char *noms_hof;
	unsigned char i;

	noms_hof = (char *) MMalloc(25);
	strcpy(noms_hof, "F.FR.RE.EG.GA.AR.RN.NI.I");

	for (i=0; i<LongHOF; i++) {
		HallOfFame[i].puntos=100;
		NStrCopy(HallOfFame[i].nombre, noms_hof, 3);
		noms_hof+=3;
		HallOfFame[i].nivel=1;
	}

	free(noms_hof);
}

//------------- Leer ficheros en SC2 -----------
void loadHOF (char *filename) {
	int file;	// Set a file handler variable

	file=Open(filename, O_RDONLY);
	// Leyendo la tabla de nombres
	Read(file, buffer_tablaNombres, TAM_TablaNombres);
	Close(file);
}

//------- Mostrar el Salon de la Fama ------------ 
void mostrarHOF(t_HallOfFame * HallOfFame, unsigned int MAX_score, unsigned int PL_score) {
	
	unsigned char i, j, fila;
	char texto[13];
	
	// Pintando el Hi-Score
	sprintf(texto, "%u", MAX_score);
	StrConcat(texto,"00");
	for (i=0; i<StrLen(texto); i++) {
		buffer_tablaNombres[(32)+30-StrLen(texto)+i] = texto[i];
	}
	// Pintando el PL-Score
	sprintf(texto, "%u", PL_score);
	StrConcat(texto,"00");
	for (i=0; i<StrLen(texto); i++) {
		buffer_tablaNombres[(32)+10-StrLen(texto)+i] = texto[i];
	}
	// Pintando la lista de puntaciones
	fila = 6;		// fila de la tabla de nombres donde empieza el ranking HOF
	for (i=0; i<LongHOF; i++) {
		// puntuacion
		sprintf(texto, "%u", HallOfFame[i].puntos);
		StrConcat(texto,"00  ");
		// nombre
		StrConcat(texto, HallOfFame[i].nombre);
		for (j=0; j<StrLen(texto); j++)		
			buffer_tablaNombres[(32*fila)+20-StrLen(texto)+j] = texto[j];
		// nivel
		sprintf(texto, "%d", HallOfFame[i].nivel);
		for (j=0; j<StrLen(texto); j++)		
			buffer_tablaNombres[(32*fila)+30-StrLen(texto)+j] = texto[j];
		// salto a la siguiente fila de la tabla de nombres
		fila +=2;
	}
	// Restaurando en VRAM la tabla de nombres del salon de la fama (buffer)	
	HideDisplay();
	CopyRamToVram (&buffer_tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);	
	ShowDisplay();
}

//---- ENTRAR EN HOF ----------	
char entrarEnHOF (t_HallOfFame * HallOfFame) {
	
	char letra = 65, posicion = 0;	
	signed char j = 0; 
	unsigned int fila;
	
	// Guardando datos en la última posición del HOF
	HallOfFame[LongHOF-1].puntos = player.PlScore;
	HallOfFame[LongHOF-1].nivel = gui.nivel;
	StrCopy(HallOfFame[LongHOF-1].nombre, "   ");
	
	// Ordenación del HOF
	quicksort (HallOfFame, LongHOF);
	
	// Buscando posición en el HOF
	while (StrCompare(HallOfFame[posicion].nombre, "   ") != 0 )
		posicion++;

	// Mostrando el nuevo HOF	
	Screen(2);
	loadSC2("menu.sc2");	// Leyendo de la pantalla del menu los tiles (patrones y colores)	
	HideDisplay();
	CopyRamToVram (&tablaPatrones[0], dirBaseTablaPatrones, TAM_TablaPatrones);
	CopyRamToVram (&tablaColor[0], dirBaseTablaColor, TAM_TablaColor);
	loadHOF("hof.scr");		// Leyendo la tabla de nombres del HOF
	mostrarHOF(HallOfFame, gui.HiScore, player.PlScore);
	
	// Guardando datos en la posición del HOF
	while (!TriggerRead(0) && !TriggerRead(1) && !TriggerRead(2)) {

			if ((JoystickRead(0) == 1) || (JoystickRead(1) == 1) || (JoystickRead(2) == 1)) {
				letra--;
				if (letra<32) letra = 126;
				PlayFX(10);
			}
			if ((JoystickRead(0) == 3) || (JoystickRead(1) == 3) || (JoystickRead(2) == 3)) {
				j++;
				if (j>2) j = 2;
				PlayFX(9);
			}
			if ((JoystickRead(0) == 5) || (JoystickRead(1) == 5) || (JoystickRead(2) == 5)) {
				letra++;
				if (letra>126) letra = 32;
				PlayFX(10);
			}
			if ((JoystickRead(0) == 7) || (JoystickRead(1) == 7) || (JoystickRead(2) == 7)) {
				j--;
				if (j<0) j = 0;
				PlayFX(9);
			}			
			fila = 32 * (6 + (posicion * 2)); // columna = 17 + j
			Vpoke (dirBaseTablaNombres+fila+17+j, letra);
			SincronizaFX(5);
			HallOfFame[posicion].nombre[j] = letra;
	} // while


	// Efecto visual finalización entrada en HOF (disparo) 
	SetColors(1, 15, 15);
	FT_wait(2);
	SetColors(1, 1, 1);

	SilencePSG();
	KillKeyBuffer();

	return 0;
}

//---- QUICKSORT ---------------
void quicksort(t_HallOfFame *V, int len) {
 
  t_HallOfFame temp;
  char i, j;
  unsigned int pivote = V[len/2].puntos;

  if (len < 2) return;
  
  // particionado
  for (i = 0, j = len - 1; ; i++, j--) {
    while (V[i].puntos > pivote) i++;
    while (V[j].puntos < pivote) j--;
 
    if (i >= j) break;
 	
 	// intercambio (temporal)
 	temp.puntos = V[i].puntos;
	temp.nivel = V[i].nivel;
	StrCopy (temp.nombre, V[i].nombre);
	// intercambio (i,j)
	V[i].puntos = V[j].puntos;
	V[i].nivel = V[j].nivel;
	StrCopy (V[i].nombre, V[j].nombre);
	V[j].puntos = temp.puntos;
	V[j].nivel = temp.nivel;
	StrCopy (V[j].nombre, temp.nombre);

  } // for
 
  quicksort(V, i);
  quicksort(V+i, len-i);
}


//----------------- MENU ------------------
char menu (t_HallOfFame * HallOfFame, unsigned int MAX_score, unsigned int PL_score) {
	
	byte buffer_menu[TAM_TablaNombres];
	unsigned char i, letra = 0;
	unsigned int inmunidad = 0;
	byte color;

	// Guardando en un buffer temporal la tabla de nombres
	// de la pantalla de menu para intercambiarla con la 
	// pantalla del salon de la fama
	CopyVramToRam (dirBaseTablaNombres, buffer_menu, TAM_TablaNombres);

	// Leyendo en el buffer de la tabla de nombres la pantalla del salon de la fama
	loadHOF("hof.scr");
	
	do {					
		
		// Lanzamiento del Temporizador
		SetRealTimer(0);
				
		//-- Buscando en la tabla de colores la 'P' de 'PUSH FIRE TO START' --
		// 
		// La direccion de inicio del BANCO 2 de la Tabla de Colores
		// tiene un offset de 2 KB (1000h) a la direccion base de la
		// Tabla. Así, por tanto, la direccion de inicio del BANCO 2
		// es la 0x3000. 
		//
		// Cada banco tiene 256 tiles de 8 bytes de informacion. La letra
		// 'P' se encuentra 25 tiles antes del final del banco. Esto
		// hace que el numero de bytes a recorrer hacia atras en la VRAM 
		// sea de 25 tiles x 8 bytes = 200 bytes antes del inicio del 
		// Banco 2 de la Tabla de Colores. 
		//
		// Cada letra (tile) tiene 8 bytes que hay que pintar con el nuevo color
		//
		// El texto 'PUSH FIRE TO START' tiene 18 tiles a pintar. Por tanto
		// hay que pintar 18 x 8 bytes (144 bytes)
		//
		//--------------------------------------------------------------------
		while (RealTimer()<Timer_Menu_MAX && !TriggerRead(0) && !TriggerRead(1)) {			
			color = 0x11;	// tinta = negro, fondo = negro			
			for (i=0; i<8*18; i++)
				Vpoke (dirBaseTablaColor+0x1000-200+i, color);
			// esperar unos segudos
			FT_wait(25);

			letra = Inkey(); // volver al MSX-DOS <- 'ESC'

			color = 0x81;	// tinta = rojo, fondo = negro
			for (i=0; i<8*18; i++)
				Vpoke (dirBaseTablaColor+0x1000-200+i, color);
			// esperar unos segudos
			FT_wait(35);
		}

		// Mostrando el Salón de la FAMA (HoF)
		if (!(RealTimer()<Timer_Menu_MAX)) {
			mostrarHOF(HallOfFame, MAX_score, PL_score);
			SetRealTimer(0);		
			while (RealTimer()<Timer_Menu_MAX && !TriggerRead(0) && !TriggerRead(1)) {
				//Inmunidad
				letra = Inkey();	// captura de tecla para la inmunidad
				if (letra == 'f' || letra =='e' || letra == 'd') inmunidad += letra;
				if (inmunidad == 404) { // fede
					player.inmunidad = true;
					SetColors (1,1,15);
					FT_wait (4);
					SetColors (1,1,1);
					inmunidad = 0;
				}
			}
			KillKeyBuffer();
		}

		// Restaurando en VRAM la tabla de nombres de la pantalla de menu
		HideDisplay();
		CopyRamToVram (&buffer_menu[0], dirBaseTablaNombres, TAM_TablaNombres);	
		ShowDisplay();

	// 0 - space key, 1 - button 1 Joystick 1
	} while (!TriggerRead(0) && !TriggerRead(1)); 

	// FX Inicio de partida
	PlayFX(1); //2
	SincronizaFX(85);

	return letra;
}

//------------ NIVELES ------------------//

//------ Carga del nivel --------------------
void loadNivel(byte nivel) {

	char mapa[6], filename[13], i, j;

	// Inicialización matriz Mundo
	for (i=0; i<MAX_ROW_WORLD; i++)
		for (j=0; j<MAX_COL_WORLD; j++)
			Mundo[i][j] = FONDO;

	// Configurando el fichero del mapa de arreglos a cargar
	sprintf(mapa, "%c", niveles[arreglo][nivel]);
	StrConcat(mapa,".map");
	// Carga del escenario y del mapa de arreglos
	switch (niveles[escenario][nivel]) {
		case 1: 
			sprintf(filename, "%s", "egipto.sc2");
			break;
		case 2: 
			sprintf(filename, "%s", "grecia.sc2");
			break;
		case 3: 
			sprintf(filename, "%s", "alemania.sc2");
			break;
		case 4: 
			sprintf(filename, "%s", "NY.sc2");
			break;
		case 5: 
			sprintf(filename, "%s", "LA.sc2");
			break;
	}

	// Leyendo Escenario 
	loadSC2(filename);
	// Guardando en el buffer_tablaNombres la tabla de nombres del escenario
	MemCopy(&buffer_tablaNombres[0], &tablaNombres[0], TAM_TablaNombres);
	// Leyendo arreglos (true -> pinta las plataformas, false -> no)
	if (niveles[escenario][nivel]!=5) loadMap(mapa, true);
	else loadMap(mapa, false);
	// Leyendo orden de encendido de las bombas
	loadTracaBombas(nivel);

}

//--------- Carga de los arreglos del nivel -----------
void loadMap(char *filename, boolean pintar_plataformas)
{

	// El mapa (plataformas y bombas) lo componen 26 caracteres x fila,
	// los primeros 24 corresponden a los patrones y los dos restantes
	// son los caracteres de fin de linea del fichero
	byte buffer_arreglos[TAM_TablaNombres-(24*6)]; // buffer fusion platformas y bombas con escenario	
	int file;			// Set a file handler variable		
	unsigned int i;

	// Cargando las plataformas y bombas
	file=Open(filename, O_RDONLY);
	Read(file, buffer_arreglos, TAM_TablaNombres-(24*6));
	// Fusionando el escenario con las plataformas y bombas
	for (i=0; i<TAM_TablaNombres-(24*6); i++)
		if (IsAlpha(buffer_arreglos[i])) {		// 'A'..'Z', 'a'..'z'
			// es una plataforma, si no es el escenario de LA se pintan
			if (IsUpper(buffer_arreglos[i])) {
				if (pintar_plataformas) {
					// Guardando en la matriz que modela el mundo que en esa
					// posicion (fila =i/26, columna = i%26) hay una plataforma
					//Mundo[i/26][i%26] = PLATAFORMA;
					Mundo[i%26][i/26] = PLATAFORMA;

					// offset entre caracteres (leido y plataforma) en el banco -> 9
					tablaNombres[32*(i/26)+(i%26)] = buffer_arreglos[i] - offsetPlataforma; 
				}			
			} else 	{	
				// Guardando en la matriz que modela el mundo que en esa
				// posicion (fila =i/26, columna = i%26) hay una bomba
				//Mundo[i/26][i%26] = BOMBA;
				Mundo[i%26][i/26] = BOMBA;

				// pintando bomba -> offset entre caracteres (leido y plataforma) en el banco -> 73
				tablaNombres[32*(i/26)+(i%26)] = buffer_arreglos[i] - offsetBomba;
			}								
		}

	// Liberando recursos
	Close(file);

}

//------ Carga del orden de explosion de las bombas
//------ devuelve el numero de tracas cargadas -> 24
char loadTracaBombas (byte nivel) {

	// El fichero de bombas lo componen 24 filas x 2 columnas de caracteres
	// los primeros 2 corresponden a las posiciones iniciales (x,y) de la esquina
	// superior izquierda de la bomba y los dos restantes son los caracteres de 
	// fin de linea del fichero
	byte buffer_bombas[25*4];	// buffer carga fichero de bombas
	int file;					// Set a file handler variable		
	char i, filename[6], nBombas = 0;

	// Configurando el fichero del a cargar
	sprintf(filename, "%c", niveles[arreglo][nivel]);
	StrConcat(filename,".bmb");
	// Leyendo el fichero
	file=Open(filename, O_RDONLY);
	Read(file, buffer_bombas, 25*4);
	// Insertamos en la lista de bombas la configuración de encendido de las mismas
	for (i=0; i<MAX_BOMBAS*4; i=i+2) 
		if (IsAlpha(buffer_bombas[i])) 
			if (IsLower(buffer_bombas[i])) {
				// insertamos la bomba en la lista de bombas
				lista_bombas[nBombas].x = (buffer_bombas[i])-'a'; 
    			lista_bombas[nBombas].y = (buffer_bombas[i+1])-'a';
				lista_bombas[nBombas].recogida = false;
    			lista_bombas[nBombas].encendida = false;				
				nBombas++;
			}

	// Liberando recursos
	Close(file);

	return nBombas;
}

//----------------- BOMBAS ------------------------------//

//-------------- encendido de una bomba --------
void enciendeBomba (t_bomba *bomba) {
	// El desplazamiento de patrones (tiles) entre la bomba
	// sin encender y la bomba encendida es de 160
	//
	// tablaNombres[posicion_origen_bomba_a_encender] += desplazamiento
	//
	if (!bomba->encendida) {
		tablaNombres[32*bomba->x+bomba->y] += 160;	
		tablaNombres[(32*bomba->x+bomba->y)+1] += 160;
		bomba->encendida = true;
	}
}

//--- pinta sobre los patrones de la bomba el fondo que había previamentes ---
void repintaFondo (byte fila, byte columna) {
	tablaNombres[32*fila+columna] = buffer_tablaNombres[32*fila+columna];
}

//-------------- eliminación de una bomba --------
unsigned int recogeBomba (t_bomba *bomba) {
	
	// Volcamos sobre la tabla de nombres los valores originales previos al
	// pintado de las bombas sobre el escenario
	bomba->recogida = true;
	repintaFondo(bomba->x,bomba->y);
	repintaFondo(bomba->x,bomba->y+1);
	repintaFondo(bomba->x+1,bomba->y);
	repintaFondo(bomba->x+1,bomba->y+1);

	// incremento de la barra de eneriga y puntos por recolección de bomba
	if (bomba->encendida) {
		gui.barraEnergia += 0.5;
		return 2;	// puntos por bomba encendida = 200
	} else {
		gui.barraEnergia += 0.25;
		return 1;	// puntos por bomba apagada = 100
	}
}

//---------------- MONEDAS ------------------------------------//

//-------- Crea una moneda nueva --------------
void crearMoneda (byte type) {

	byte posicion;

	if (nMonedas < MAX_MONEDAS) {
		// búsqueda de la posición en la que insertar la moneda nueva
		if (listaMonedas[0].activa == false) posicion = 0; else posicion = 1;
		// inserción de la moneda en la posición libre
		listaMonedas[posicion].id = MONEDA;
		listaMonedas[posicion].tipo = type;
		// Aparece desde el centro de la pantalla (salvo la moneda BONUS)
		listaMonedas[posicion].x = SCREEN_WIDTH/2;
		listaMonedas[posicion].y = SCREEN_HEIGHT/2;
		listaMonedas[posicion].dx = velocidad >> 4;	// la misma que el avatar
		listaMonedas[posicion].dy = velocidad >> 4;	// la misma que el avatar
		listaMonedas[posicion].time = 0;
		listaMonedas[posicion].fila = listaMonedas[posicion].y/MAX_ROW_WORLD;
		listaMonedas[posicion].columna = listaMonedas[posicion].x/MAX_COL_WORLD;
		listaMonedas[posicion].activa = true;
		listaMonedas[posicion].grounded = false;
		listaMonedas[posicion].ceiling = false;
		listaMonedas[posicion].leftBounded = false;
		listaMonedas[posicion].rightBounded = false;
		switch (type) {
			case B: // BONUS
				listaMonedas[posicion].spriteInicio = monedaBonus;	
				listaMonedas[posicion].color = azul_celeste;
				// Aparece desde lo alto de la pantalla
				listaMonedas[posicion].x = FT_RandomNumber(0,SCREEN_WIDTH-16);
				listaMonedas[posicion].y = 0;
				break;
			case P: // POWER
				listaMonedas[posicion].spriteInicio = monedaPower;
				listaMonedas[posicion].color = azul_celeste;
				break;
			case E: // EXTRA
				listaMonedas[posicion].spriteInicio = monedaExtra;
				listaMonedas[posicion].color = verde_claro;
				break;
			case S: // SPECIAL
				listaMonedas[posicion].spriteInicio = monedaEspecial;
				listaMonedas[posicion].color = rojo_claro;
				// Aparece desde lo alto de la pantalla
				listaMonedas[posicion].x = FT_RandomNumber(0,SCREEN_WIDTH-16);
				listaMonedas[posicion].y = 0;
				break;
		}
		listaMonedas[posicion].spriteActual = listaMonedas[posicion].spriteInicio;
		// Plano
		switch (posicion) {
			case 0: 
				if (listaMonedas[1].plano == planoInicialVDPMonedas)
					listaMonedas[0].plano = planoInicialVDPMonedas+1;
				else listaMonedas[0].plano = planoInicialVDPMonedas;
				break;
			case 1:
				if (listaMonedas[0].plano == planoInicialVDPMonedas)
					listaMonedas[1].plano = planoInicialVDPMonedas+1;
				else listaMonedas[1].plano = planoInicialVDPMonedas;
				break;
		}

		nMonedas++;
	}

}

//-------- Actualiza una moneda ---------------
void actualizaMoneda (t_Moneda *moneda, unsigned int frame) {

	if (moneda->activa) {
		
		// animación
		if (frame % 3 == 0)
			if (moneda->spriteActual == moneda->spriteInicio) moneda->spriteActual = monedaCanto;
			else if (moneda->spriteActual == monedaCanto) moneda->spriteActual = moneda->spriteInicio + 4; // sprite moneda espejo
				else moneda->spriteActual = moneda->spriteInicio;

		// grounded
		moneda->grounded = ((moneda->y > SCREEN_HEIGHT-18) || 		
			Mundo[moneda->columna][moneda->fila+2] == PLATAFORMA || 
			Mundo[moneda->columna+1][moneda->fila+2] == PLATAFORMA);
		// ceiling (corrección al pixel de la distancia del sprite del avatar al patrón de la plataforma -> player.y-(player.fila*8))== 0
		moneda->ceiling = ((moneda->y < 0) || 		
			(Mundo[moneda->columna][moneda->fila-1] == PLATAFORMA || 
			Mundo[moneda->columna+1][moneda->fila-1] == PLATAFORMA) && 
			!(moneda->y - (moneda->fila * 8) > 0));
		// leftBounded
		moneda->leftBounded = ((moneda->x < 0) || 		
			(Mundo[moneda->columna-1][moneda->fila] == PLATAFORMA ||
			Mundo[moneda->columna-1][moneda->fila+1] == PLATAFORMA) &&
			(moneda->x - (moneda->columna) * 8) <= 0);	// corrección al pixel de la distancia del sprite del avatar al patrón de la plataforma
		// rightBounded
		moneda->rightBounded = ((moneda->x > SCREEN_HEIGHT-16) || 		
			(Mundo[moneda->columna+2][moneda->fila] == PLATAFORMA ||
			Mundo[moneda->columna+2][moneda->fila+1] == PLATAFORMA));

		// simulación física
		switch (moneda->tipo) {
			case B: // BONUS
				if (!moneda->grounded) moneda->y += moneda->dy;
				else {
					if (moneda->leftBounded || moneda->rightBounded) 
						moneda->dx = moneda->dx * (-1);
					moneda->x += moneda->dx;
				}
				break;
			case E: // EXTRA
			case S: // SPECIAL				
				if (moneda->grounded || moneda->ceiling) moneda->dy = moneda->dy * (-1);
				if (moneda->leftBounded || moneda->rightBounded) moneda->dx = moneda->dx * (-1);
				moneda->x += moneda->dx;
				moneda->y += moneda->dy;
				break;
			case P: // POWER
				if (moneda->grounded || moneda->ceiling) moneda->dy = moneda->dy * (-1);
				if (moneda->leftBounded || moneda->rightBounded) moneda->dx = moneda->dx * (-1);
				moneda->x += moneda->dx;
				moneda->y += moneda->dy;
				// actualización del color
				if (frame % 25 == 0) {
					switch (moneda->color) {
						case azul_celeste: 	
							moneda->color = rojo_claro; break;
						case rojo_claro:
							moneda->color = magenta; 	break;
						case magenta:
							moneda->color = verde_claro; break;
						case verde_claro:
							moneda->color = azul_claro;	 break;
						case azul_claro:
							moneda->color = amarillo_claro; break;
						case amarillo_claro:
							moneda->color = gris; break;
						case gris:
							moneda->color = azul_celeste; break;
					}
				}
				// actualización FX moneda 'P'
				PlayFX(2);
				break;
		}

		// actualización de la nueva posición de la moneda en matriz Mundo
		moneda->fila = moneda->y/TAM_celda_Mundo;
		moneda->columna = moneda->x/TAM_celda_Mundo;
		
		// tiempo de actividad
		moneda->time++;
		if (moneda->time > Timer_monedaActiva) {
			nMonedas--;
			// borrado de la moneda en pantalla
			moneda->activa = false;
			moneda->y = 209;
			moneda->x = -32;
			PutSprite (moneda->plano, moneda->spriteActual, moneda->x, moneda->y, moneda->color);
		}
	}	
}

//------ Dibuja las monedas en pantalla ------------
void dibujaMoneda (byte moneda) {

	byte registroEstadoVDP;

	// comprobación regla 5º sprite
	registroEstadoVDP = VDPstatus(0);
	if ((nMonedas == MAX_MONEDAS) && ((registroEstadoVDP & 0x40) == 0x40) && ((registroEstadoVDP & 0x1F) >= planoInicialVDPMonedas)) {
		// se incumple la regla del 5º sprite por parte de una moneda	
		// rotación del plano en el que se dibuja el sprite para su visualización
		switch (listaMonedas[0].plano) {
			case planoInicialVDPMonedas:
				listaMonedas[0].plano = planoInicialVDPMonedas+1;
				listaMonedas[1].plano = planoInicialVDPMonedas;
			break;
			case planoInicialVDPMonedas+1:
				listaMonedas[0].plano = planoInicialVDPMonedas;
				listaMonedas[1].plano = planoInicialVDPMonedas+1;
			break;
		}
	}
	// en pantalla
	PutSprite (listaMonedas[moneda].plano, listaMonedas[moneda].spriteActual, listaMonedas[moneda].x,listaMonedas[moneda].y, listaMonedas[moneda].color);
	// actualización de la nueva posición
	if (listaMonedas[moneda].activa) {
		listaMonedas[moneda].fila = listaMonedas[moneda].y/TAM_celda_Mundo;
		listaMonedas[moneda].columna = listaMonedas[moneda].x/TAM_celda_Mundo;
	}
}

//-------------------- ENEMIGOS --------------------------------------//

//------ Crea un enemigo principal nuevo al final de la lista -------------
void creaEnemigoPrincipal (void) {

	// orientación aleatoria del enemigo (0 -> derecha, 1 -> izquierda)
	listaEnemigos[nEnemigos].orientacion = FT_RandomNumber(0,2);
	// creación aleatoria del tipo enemigo principal (2 -> pájaro, 3 -> momia)
	listaEnemigos[nEnemigos].id = FT_RandomNumber(2,4);
	// comprobación de no superar el numero de pájaros por nivel
	// según la fórmula: npajaros = ( nº_nivel / 10) + 1
	if ((nPajaros<(gui.nivel/10)+1) && (listaEnemigos[nEnemigos].id == PAJARO)) nPajaros++;
	else listaEnemigos[nEnemigos].id = MOMIA;
	switch (listaEnemigos[nEnemigos].id) {
		case PAJARO: // enemigo tipo pájaro
			// aparecen en cualquiera de las 4 esquinas de la pantalla
			if (listaEnemigos[nEnemigos].orientacion) {		// mira a la izquierda
				listaEnemigos[nEnemigos].spriteInicio = pajaroIzq;
				listaEnemigos[nEnemigos].x = SCREEN_WIDTH-16;
			} else {	// mira a la derecha
				listaEnemigos[nEnemigos].spriteInicio = pajaroDer;
				listaEnemigos[nEnemigos].x = 0;
			}
			listaEnemigos[nEnemigos].eje = false; // eje HORIZONTAL
			listaEnemigos[nEnemigos].y = FT_RandomNumber(0,2);	// 0 -> arriba, 1 -> abajo
			if (listaEnemigos[nEnemigos].y) listaEnemigos[nEnemigos].y = SCREEN_HEIGHT-16;	
			// su velocidad se incrementa al alcanzar la mitad de niveles
			listaEnemigos[nEnemigos].dx = (gui.nivel/32)+1;
			listaEnemigos[nEnemigos].dy = (gui.nivel/32)+1;
			break;
		case MOMIA: // enemigo tipo momia
			// aparecen desde la parte alta de la pantalla
			if (!listaEnemigos[nEnemigos].orientacion) { // mira a la derecha
				listaEnemigos[nEnemigos].spriteInicio = momiaDerecha;		
				listaEnemigos[nEnemigos].x = SCREEN_WIDTH-32;
				listaEnemigos[nEnemigos].orientacion = LOOK_RIGHT;
			} else { // mira a la izquierda
				listaEnemigos[nEnemigos].spriteInicio = momiaIzquierda;	// mira a la izquierda
				listaEnemigos[nEnemigos].x = 32;
				listaEnemigos[nEnemigos].orientacion = LOOK_LEFT;
			}
			listaEnemigos[nEnemigos].y = 0;		// arriba
			listaEnemigos[nEnemigos].dx = velocidad & 0x03;
			listaEnemigos[nEnemigos].dy = velocidad & 0x03;
			// IA (en la primera mitad de los niveles camina por las plataformas el tiempo indicado antes de caer)
			// eje <- multiplicador de esperar el tiempo sobre una plataforma antes de caer
			listaEnemigos[nEnemigos].eje = (gui.nivel < MAX_NIVELES/2);
			break;
	}
	listaEnemigos[nEnemigos].fila = listaEnemigos[nEnemigos].y/MAX_ROW_WORLD;		// conversión de la coordenada 'y' a la matriz Mundo
	listaEnemigos[nEnemigos].columna = listaEnemigos[nEnemigos].x/MAX_COL_WORLD;	// conversión de la coordenada 'x' a la matriz Mundo	
	listaEnemigos[nEnemigos].plano = planoInicialVDPEnemigos + nEnemigos;			// plano del VDP en el que se situa	
	listaEnemigos[nEnemigos].grounded = false;
	listaEnemigos[nEnemigos].ceiling = false;
	// Número máximo de sprites que forman la animación
	listaEnemigos[nEnemigos].spriteActual = listaEnemigos[nEnemigos].spriteInicio;	
	listaEnemigos[nEnemigos].estadoActual = ALIVE;		// estado actual de su máquina de estados

	++nEnemigos;
}

//-------- Crea un enemigo secundario ----------------
void creaEnemigoSecundario (byte enemigo) {
	// creación aleatoria del tipo enemigo secundario (4 - 9)
	listaEnemigos[enemigo].id = FT_RandomNumber(4,9);
	listaEnemigos[enemigo].estadoActual = ALIVE;
	// fijación del patrón sprite inicial según la orientación del enemigo
	switch (listaEnemigos[enemigo].id) {
		case ESFERA:
			listaEnemigos[enemigo].spriteInicio = esferaDerecha; 		
			listaEnemigos[enemigo].dx = velocidad & 0x0F;
			break;
		case ORBE:
			listaEnemigos[enemigo].spriteInicio = orbeDerecha;
			listaEnemigos[enemigo].dx = velocidad & 0x0F;
			break;
		case OVNI:
			listaEnemigos[enemigo].spriteInicio = ovniDerecha;
			listaEnemigos[enemigo].dx = 1;	// su velocidad no depende del nivel
			listaEnemigos[enemigo].dy = 1;	// su velocidad no depende del nivel
			listaEnemigos[enemigo].eje = false;
			listaEnemigos[enemigo].temporizador = 1;
			break;
		case CUERNO:
			listaEnemigos[enemigo].spriteInicio = cuernoDerecha;		
			listaEnemigos[enemigo].dx = velocidad & 0x0F;
			break;
		case SATELITE:
			listaEnemigos[enemigo].spriteInicio = sateliteDerecha;
			listaEnemigos[enemigo].dx = 1;	// su velocidad no depende del nivel
			listaEnemigos[enemigo].dy = 1;	// su velocidad no depende del nivel
			break;
	}
	listaEnemigos[enemigo].spriteActual = listaEnemigos[enemigo].spriteInicio;
}

//----- Actualización del estado de los enemigos ------
void actualizaEnemigos(t_Enemigo *enemigo, unsigned int frame, byte i) {
	
	//--- Detección colisión con los límites de la pantalla y las plataformas ---
	
	// grounded
	enemigo->grounded = (enemigo->y > SCREEN_HEIGHT-18 || 
		Mundo[enemigo->columna][enemigo->fila+2] == PLATAFORMA || 
		Mundo[enemigo->columna+1][enemigo->fila+2] == PLATAFORMA);
	// ceiling (corrección al pixel de la distancia del sprite al patrón de la plataforma -> enemigo.y-(enemigo.fila*8))== 0
	enemigo->ceiling = (enemigo->y < 1 || 		
		(Mundo[enemigo->columna][enemigo->fila-1] == PLATAFORMA && 
		!(enemigo->y - (enemigo->fila * 8) > 1/*0*/)));
	// leftBounded
	enemigo->leftBounded = (enemigo->x < 1 || 		
		((Mundo[enemigo->columna-1][enemigo->fila] == PLATAFORMA ||
		Mundo[enemigo->columna-1][enemigo->fila+1] == PLATAFORMA) &&
		(enemigo->x - (enemigo->columna) * 8) < 1));	// corrección al pixel de la distancia del sprite al patrón de la plataforma
	// rightBounded
	enemigo->rightBounded = (enemigo->x > SCREEN_HEIGHT-16 || 		
		(Mundo[enemigo->columna+2][enemigo->fila] == PLATAFORMA ||
		Mundo[enemigo->columna+2][enemigo->fila+1] == PLATAFORMA));
	
	// orientación del enemigo	
	if (enemigo->id != MOMIA)
		if (enemigo->x < player.x) enemigo->orientacion = LOOK_RIGHT;
		else enemigo->orientacion = LOOK_LEFT;
	
	//--- animación ---
	if (enemigo->estadoActual == ALIVE)
		if (enemigo->spriteActual == enemigo->spriteInicio) 
			enemigo->spriteActual = enemigo->spriteInicio + 4;
		else enemigo->spriteActual = enemigo->spriteInicio;

	//--- Simulación física e IA ---
	switch (enemigo->estadoActual) {
		case ALIVE:
			switch (enemigo->id) {
				case PAJARO:			
					// animación
					if (frame % 4 == 0)			
						switch (enemigo->orientacion) {
							case LOOK_RIGHT:
								enemigo->spriteInicio = pajaroDer;
								break;
							case LOOK_LEFT:
								enemigo->spriteInicio = pajaroIzq;
								break;
						}
					// avance en un solo eje
					if (!enemigo->eje)
						// movimiento eje X buscando a JACK
						switch (enemigo->orientacion) {
							case LOOK_RIGHT:
								if (!enemigo->rightBounded) enemigo->x += enemigo->dx;
								break;
							case LOOK_LEFT:
								if (!enemigo->leftBounded) enemigo->x -= enemigo->dx;
								break;
						}
					else // movimiento eje Y buscando a JACK 				
						if ((enemigo->y < player.y) && !enemigo->grounded) 
							enemigo->y += enemigo->dy;
						else if ((enemigo->y > player.y) && !enemigo->ceiling) 
							enemigo->y -= enemigo->dy;
					// actualización del eje de movimiento
					if (FT_RandomNumber (0,9) == 3) enemigo->eje = !enemigo->eje;
					break;
				case MOMIA:	
					// animación
					if (frame % 4 == 0) {
						switch (enemigo->orientacion) {
							case LOOK_RIGHT:
								enemigo->spriteInicio = momiaDerecha;
								break;
							case LOOK_LEFT:
								enemigo->spriteInicio = momiaIzquierda;
								break;							
						}
					}	
					if (!enemigo->grounded) { 
						enemigo->y += enemigo->dy;
						enemigo->temporizador = RealTimer();
					} else { // grounded
						switch (enemigo->orientacion) {
							case LOOK_RIGHT:
								// caminar sobre la plataforma
								if (RealTimer() < enemigo->temporizador + Timer_momia) {
									if (Mundo[enemigo->columna+1][enemigo->fila+2] != PLATAFORMA || enemigo->rightBounded)
										 enemigo->orientacion = LOOK_LEFT;
									else enemigo->x += enemigo->dx;
								} else // probabilidad alta de caer
									if (!enemigo->rightBounded) enemigo->x += enemigo->dx;
									else enemigo->orientacion = LOOK_LEFT;
								break;
							case LOOK_LEFT:
								// probabilidad baja de caer
								if (RealTimer() < enemigo->temporizador + Timer_momia) {
									if (Mundo[enemigo->columna][enemigo->fila+2] != PLATAFORMA || enemigo->leftBounded)
										 enemigo->orientacion = LOOK_RIGHT;
									else enemigo->x -= enemigo->dx;
								} else // probabilidad alta de caer
									if (!enemigo->leftBounded) enemigo->x -= enemigo->dx;
									else enemigo->orientacion = LOOK_RIGHT;
								break;
						}						
					}
					// Conversión enemigo principal en secundario
					if (enemigo->y > SCREEN_HEIGHT-18)
						creaEnemigoSecundario(i);
					break;
				case ESFERA:	
					if (enemigo->grounded || enemigo->ceiling)
						enemigo->dy = enemigo->dy * (-1);	// cambio sentido dirección eje Y
					enemigo->y += enemigo->dy;
					// avance sobre el eje X buscando a JACK
					if (enemigo->leftBounded || enemigo->rightBounded) 
						enemigo->dx = enemigo->dx * (-1);	// cambio sentido dirección eje X
					enemigo->x += enemigo->dx;				
					break;
				case ORBE:
					if (enemigo->rightBounded || enemigo->leftBounded)
						enemigo->dx = enemigo->dx * (-1);	// cambio sentido dirección eje X al rebotar
					enemigo->x += enemigo->dx;
					// movimiento eje Y buscando a JACK
					if ((enemigo->y < player.y) && !enemigo->grounded) 
						enemigo->y += enemigo->dy;
					else if ((enemigo->y > player.y) && !enemigo->ceiling) 
						enemigo->y -= enemigo->dy;				
					break;
				case OVNI:
					// colisión con plataformas o límites de la pantalla
					if (enemigo->rightBounded || enemigo->leftBounded) {
						enemigo->dx = enemigo->dx * (-1);
						enemigo->temporizador = RealTimer();
					}
					// aceleración al estar cerca del avatar (sólo eje X)
					if (abs(player.x - enemigo->x) < SCREEN_WIDTH / 4) {
						enemigo->temporizador = RealTimer();
					}
					// simulación física
					// movimiento sobre eje X
					if (enemigo->temporizador != 1 && enemigo->temporizador < RealTimer() + Timer_ovni)
						enemigo->dx = 4 * (enemigo->dx / abs(enemigo->dx));
					else {
						enemigo->dx /= abs(enemigo->dx);
						enemigo->temporizador = 1;
					}
					enemigo->x += enemigo->dx;
					// movimiento eje Y (buscando a JACK)
					if ((enemigo->y < player.y) && !enemigo->grounded) 
						enemigo->y += enemigo->dy;
					else if ((enemigo->y > player.y) && !enemigo->ceiling) 
						enemigo->y -= enemigo->dy;				
					break;
				case CUERNO:
					// movimiento eje X buscando a JACK
					switch (enemigo->orientacion) {
						case LOOK_RIGHT:
							if (!enemigo->rightBounded) enemigo->x += enemigo->dx;
							break;
						case LOOK_LEFT:
							if (!enemigo->leftBounded) enemigo->x -= enemigo->dx;
							break;
					}
					// movimiento eje Y buscando a JACK
					if ((enemigo->y < player.y) && !enemigo->grounded) 
						enemigo->y += enemigo->dy;
					else if ((enemigo->y > player.y) && !enemigo->ceiling) 
						enemigo->y -= enemigo->dy;		
					break;
				case SATELITE:
					if (enemigo->grounded || enemigo->ceiling) enemigo->dy = enemigo->dy * (-1);
					if (enemigo->leftBounded || enemigo->rightBounded) enemigo->dx = enemigo->dx * (-1);
					enemigo->x += enemigo->dx;
					enemigo->y += enemigo->dy;
					break;	
			}
			break;
		case MONEDA:	// Moneda ORO
			enemigo->spriteActual = monedaOro;
			// Vencimiento del temporizador de estado Moneda Oro
			if (RealTimer() > enemigo->temporizador + (Timer_monedaActiva >> 1)) {
				// Recuperación estado anterior a moneda oro
				enemigo->estadoActual = ALIVE;
				enemigo->spriteActual = enemigo ->spriteInicio;
				nMonedasORO--;
			}
			break;
		case DEAD:
			enemigo->y = 209; // ocultación del sprite en pantalla
			enemigo->x = -32;
			break;
	}

	// actualización de la nueva posición en la matriz Mundo
	if (enemigo->estadoActual != DEAD) {
		enemigo->fila = enemigo->y/TAM_celda_Mundo;
		enemigo->columna = enemigo->x/TAM_celda_Mundo;
	}

}

//---- Reordena la lista de Enemigos tras la recolección de una Moneda ORO ------
boolean ordenaListaEnemigos (void) {

byte posicion = 0; 

	// Busqueda de la posición del enemigo muerto
	while (listaEnemigos[posicion].estadoActual != DEAD) posicion++;
	// Caso que el enemigo muerto no sea el último de la lista hay que intercambiar enemigos de posición
	// hay que tener en cuenta que la actualización de colisiones resta en una unidad el nº de enemigos
	if (posicion < nEnemigos) { 		
		// intercambiamos con el último de la lista
		listaEnemigos[posicion].id = listaEnemigos[nEnemigos].id; 
		listaEnemigos[posicion].spriteActual = listaEnemigos[nEnemigos].spriteActual;
		listaEnemigos[posicion].spriteInicio = listaEnemigos[nEnemigos].spriteInicio;
		listaEnemigos[posicion].x1 = listaEnemigos[nEnemigos].x1;
		listaEnemigos[posicion].x2 = listaEnemigos[nEnemigos].x2;
		listaEnemigos[posicion].y1 = listaEnemigos[nEnemigos].y1;
		listaEnemigos[posicion].y2 = listaEnemigos[nEnemigos].y2;
		listaEnemigos[posicion].fila = listaEnemigos[nEnemigos].fila;
		listaEnemigos[posicion].columna = listaEnemigos[nEnemigos].columna;
		listaEnemigos[posicion].estadoActual = listaEnemigos[nEnemigos].estadoActual;
		listaEnemigos[posicion].orientacion = listaEnemigos[nEnemigos].orientacion;
		listaEnemigos[posicion].temporizador = listaEnemigos[nEnemigos].temporizador;
		listaEnemigos[posicion].x = listaEnemigos[nEnemigos].x;
		listaEnemigos[posicion].y = listaEnemigos[nEnemigos].y;
		listaEnemigos[posicion].dx = listaEnemigos[nEnemigos].dx;
		listaEnemigos[posicion].dy = listaEnemigos[nEnemigos].dy;
		listaEnemigos[posicion].eje = listaEnemigos[nEnemigos].eje;
		listaEnemigos[posicion].grounded = listaEnemigos[nEnemigos].grounded;
		listaEnemigos[posicion].ceiling = listaEnemigos[nEnemigos].ceiling;
		listaEnemigos[posicion].leftBounded = listaEnemigos[nEnemigos].leftBounded;
		listaEnemigos[posicion].rightBounded =listaEnemigos[nEnemigos].rightBounded;		
		// Reasignación de planos para que cada posición se dibuje en su plano de origen
		for (posicion = 0; posicion <= nEnemigos; posicion++)
			listaEnemigos[posicion].plano = planoInicialVDPEnemigos + posicion;
		// Ocultación del sprite del último enemigo en la pantalla
		listaEnemigos[nEnemigos].x = -32;
		listaEnemigos[nEnemigos].y = 209;
		PutSprite (listaEnemigos[nEnemigos].plano, listaEnemigos[nEnemigos].spriteActual, listaEnemigos[nEnemigos].x, listaEnemigos[nEnemigos].y, negro);
	}

	// Desativación de la bandera de reordenar la lista de enemigos
	return false;
}

//------------ Dibuja enemigo en pantalla ------------
void dibujaEnemigo (byte enemigo) {

	byte color, i, registroEstadoVDP;
	byte ultimoPlano = planoInicialVDPEnemigos+nEnemigos-1;

	if (listaEnemigos[enemigo].estadoActual != DEAD) {
		switch (listaEnemigos[enemigo].id) {
			case PAJARO: color = blanco;
				break;
			case ORBE: color = negro;
				break;
			default: color = gris; 
		}
		if (listaEnemigos[enemigo].estadoActual == MONEDA) {
			if (RealTimer() % 2 == 0)
				color = gris;		// brillo de la moneda
			else color = amarillo_oscuro;		
		}
		// comprobación regla 5º sprite por parte de los enemigos
		registroEstadoVDP = VDPstatus(0);
		if (!nMonedasORO && ((registroEstadoVDP & 0x40) == 0x40) && ((registroEstadoVDP & 0x1F) < planoInicialVDPMonedas)) {
			// se incumple la regla del 5º sprite		
			// rotación del plano en el que se dibuja el sprite para su visualización
			for (i=0; i<nEnemigos; i++) {
				if (listaEnemigos[i].plano < ultimoPlano)
					listaEnemigos[i].plano++;
				else listaEnemigos[i].plano = planoInicialVDPEnemigos;
			}
		}
		// en pantalla
		PutSprite (listaEnemigos[enemigo].plano, listaEnemigos[enemigo].spriteActual,listaEnemigos[enemigo].x,listaEnemigos[enemigo].y, color);
		// actualización de la nueva posición del avatar
		listaEnemigos[enemigo].fila = listaEnemigos[enemigo].y/TAM_celda_Mundo;
		listaEnemigos[enemigo].columna = listaEnemigos[enemigo].x/TAM_celda_Mundo;
	}
}

//----------------------- AVATAR -----------------------------------//

//----- Inicialización del estado del avatar ------
void inicializaAvatar (void) {
	
	player.x = SCREEN_WIDTH/2;
	player.y = SCREEN_HEIGHT/2;
	player.dx = velocidad >> 4; 
	player.dy = velocidad >> 4; 
	player.fila = player.y/TAM_celda_Mundo;
	player.columna = player.x/TAM_celda_Mundo;
	player.plano = 0;	
	player.spriteInicio = reposo;	
	player.spriteActual = player.spriteInicio;
	player.bombas = player.enemigos = 0;
	player.cuentaSalto = 0;
	player.estadoActual = IDLE;
	player.grounded = player.ceiling = player.leftBounded = player.rightBounded = false;

}

//----- Actualización del estado del avatar ------
void actualizaAvatar (t_Entrada *entrada) {

	// grounded
	player.grounded = ((player.y > SCREEN_HEIGHT-19) || 		
		Mundo[player.columna][player.fila+2] == PLATAFORMA || 
		Mundo[player.columna+1][player.fila+2] == PLATAFORMA);
	// ceiling (corrección al pixel de la distancia del sprite del avatar al patrón de la plataforma -> player.y-(player.fila*8))== 0
	player.ceiling = ((player.y < 0) || 		
		(Mundo[player.columna][player.fila-1] == PLATAFORMA || 
		Mundo[player.columna+1][player.fila-1] == PLATAFORMA) && 
		!(player.y - (player.fila * 8) > 0));
	// leftBounded
	player.leftBounded = ((player.x <= 0) || 		
		(Mundo[player.columna-1][player.fila] == PLATAFORMA ||
		Mundo[player.columna-1][player.fila+1] == PLATAFORMA) &&
		(player.x - (player.columna) * 8) <= 0);	// corrección al pixel de la distancia del sprite del avatar al patrón de la plataforma
	// rightBounded
	player.rightBounded = ((player.x > SCREEN_HEIGHT-16) || 		
		(Mundo[player.columna+2][player.fila] == PLATAFORMA ||
		Mundo[player.columna+2][player.fila+1] == PLATAFORMA));
	
	// máquina de estados
	switch (player.estadoActual) {
		case IDLE: 
			if (player.grounded) {
				// salidas del estado
				player.spriteActual = reposo;				
				// transiciones
				switch (entrada->movimiento) {
					case reposo:
						if (entrada->salto) {
							player.estadoActual = JUMP;
							// acciones de salida del estado
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						}
						break;
					case arriba:
						if (entrada->salto) {
							player.estadoActual = J_HIGH;
							PlayFX(3);	// FX salto
						}
						break;						
					case abajoIzquierda:
					case izquierda:
						if (entrada->salto) {
							player.estadoActual = J_LEFT;
							// acciones de salida del estado
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						} else player.estadoActual = W_LEFT;
						break;
					case arribaIzquierda: 
						if (entrada->salto) {
							player.estadoActual = J_HIGH_LEFT;
							PlayFX(3);	// FX salto
						} else player.estadoActual = W_LEFT;
						break;	
					case abajoDerecha:
					case derecha:
						if (entrada->salto) {
							player.estadoActual = J_RIGHT;
							// acciones de salida del estado
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						} else player.estadoActual = W_RIGHT;
						break;
					case arribaDerecha: 
						if (entrada->salto) {
							player.estadoActual = J_HIGH_RIGHT;
							PlayFX(3);	// FX salto
						} else player.estadoActual = W_RIGHT;
						break;										
				}
			} else { // !player.grounded
				switch (entrada->movimiento) { // transiciones
					case reposo:
						player.estadoActual = FALLING;
						break;
				}
			}
			break;
		case W_LEFT: 
			if (player.grounded) {
				// salidas del estado
				if (player.spriteActual == andarIzqQuieto) // animación del sprite
					player.spriteActual = andarIzqMov;
				else player.spriteActual = andarIzqQuieto;
				if (!player.leftBounded) { 
					player.x -= player.dx;
				}
				// transiciones
				switch (entrada->movimiento) {
					case arriba:
					case abajo:
					case reposo:
						player.estadoActual = IDLE;
						break;
					case abajoIzquierda:
					case izquierda:
						if (!entrada->salto) player.estadoActual = W_LEFT;
						else {
							player.estadoActual = J_LEFT;
							// acciones de salida del estado
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						}
						break;
					case arribaIzquierda: 
						if (entrada->salto) {
							player.estadoActual = J_HIGH_LEFT;
							PlayFX(3);	// FX salto
						} else player.estadoActual = W_LEFT;
						break;
					case abajoDerecha:
					case derecha:
						if (!entrada->salto) player.estadoActual = W_RIGHT;
						else {
							player.estadoActual = J_RIGHT;
							// acciones de salida del estado
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						}
						break;
					case arribaDerecha: 
						if (!entrada->salto) player.estadoActual = W_RIGHT;
						else {
							player.estadoActual = J_HIGH_RIGHT;
							PlayFX(3);	// FX salto
						}
						break;						
				}
			} else player.estadoActual = FALLING;// !player.grounded
			break;
		case W_RIGHT: 
			if (player.grounded) {
				// salidas del estado
				if (player.spriteActual == andarDerQuieto) 
					player.spriteActual = andarDerMov;
				else player.spriteActual = andarDerQuieto;
				if (!player.rightBounded) {
					player.x += player.dx;
				}
				// transiciones
				switch (entrada->movimiento) {
					case arriba:
					case abajo:
					case reposo:
						player.estadoActual = IDLE;
						break;
					case abajoDerecha:
					case derecha:
						if (entrada->salto) {
							player.estadoActual = J_RIGHT;
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						}
						break;
					case arribaDerecha: 
						if (entrada->salto) {
							player.estadoActual = J_HIGH_RIGHT;
							PlayFX(3);	// FX salto
						}
						break;
					case abajoIzquierda:
					case izquierda:
						if (!entrada->salto) player.estadoActual = W_LEFT;
						else {
							player.estadoActual = J_LEFT;
							player.cuentaSalto = 0;
							PlayFX(3);	// FX salto
						}
						break;
					case arribaIzquierda: 
						if (entrada->salto) {
							player.estadoActual = J_HIGH_LEFT;
							PlayFX(3);	// FX salto
						}
						break;	
				}
			} else player.estadoActual = FALLING;	// !player.grounded
			break;
		case JUMP: 			
			if (!player.ceiling && (player.cuentaSalto < Timer_Salto_MAX)) {
				// salidas del estado			
				player.spriteActual = saltar;
				player.y -= player.dy;
				player.cuentaSalto += player.dy;				
				// transiciones	
				switch (entrada->movimiento) {
					case abajo:
					case reposo:
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = FALLING;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (!entrada->salto) player.estadoActual = J_LEFT;
						else player.estadoActual = F_LEFT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (!entrada->salto) player.estadoActual = J_RIGHT;
						else player.estadoActual = F_RIGHT;
						break;
				}				
			} else player.estadoActual = FALLING;			
			break;
		case J_LEFT:
			if (!player.ceiling && (player.cuentaSalto < Timer_Salto_MAX)) {
				// salidas del estado
				player.spriteActual = saltarIzq;
				player.cuentaSalto += player.dy;
				player.y -= player.dy;
				// comprobación límite izquierdo
				if (!player.leftBounded) player.x -= player.dx;
				// transiciones	
				switch (entrada->movimiento) { 				
					case reposo: 
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_LEFT;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_LEFT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_RIGHT;
						else player.estadoActual = J_RIGHT;
						break;
					case arriba:
						player.estadoActual = JUMP;
						break;
				}
			} else player.estadoActual = FALLING; // transiciones
			break;
		case J_RIGHT:
			if (!player.ceiling && (player.cuentaSalto < Timer_Salto_MAX)) {
				// salidas del estado
				player.spriteActual = saltarDer;
				player.cuentaSalto += player.dy;
				player.y -= player.dy;
				// comprobación límite izquierdo
				if (!player.rightBounded) player.x += player.dx;
				// transiciones	
				switch (entrada->movimiento) { 				
					case reposo: 
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_RIGHT;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_LEFT;
						else player.estadoActual = J_LEFT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (player.cuentaSalto>30 && entrada->salto) player.estadoActual = F_RIGHT;
						break;
					case arriba:
						player.estadoActual = JUMP;
						break;
				}
			} else player.estadoActual = FALLING; // transiciones
			break;
		case J_HIGH:
			if (!player.ceiling) {
				// salidas del estado
				player.spriteActual = saltar;
				player.y -= player.dy;
				// transiciones	
				switch (entrada->movimiento) {								
					case reposo:				
						if (entrada->salto)
							player.estadoActual = FALLING;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (!entrada->salto) player.estadoActual = J_HIGH_LEFT;
						else player.estadoActual = F_LEFT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (!entrada->salto) player.estadoActual = J_HIGH_RIGHT;
						else player.estadoActual = F_RIGHT;
						break;
				}
			} else player.estadoActual = FALLING; // transiciones
			break;
		case J_HIGH_LEFT:
			if (!player.ceiling) {
				// salidas del estado
				player.spriteActual = saltarIzq;
				// comprobación límite izquierdo
				if (!player.leftBounded) player.x -= player.dx;			
				player.y -= player.dy;
				// transiciones	
				switch (entrada->movimiento) { 				
					case reposo: 
						if (entrada->salto) player.estadoActual = F_LEFT;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (entrada->salto) player.estadoActual = F_LEFT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (entrada->salto) player.estadoActual = F_RIGHT;
						break;
					case arriba:
						player.estadoActual = J_HIGH;
						break;
				}
			} else player.estadoActual = FALLING; // transiciones
			break;			
		case J_HIGH_RIGHT: 
			if (!player.ceiling) {
				// salidas del estado
				player.spriteActual = saltarDer;
				// comprobación límite derecho
				if (!player.rightBounded) player.x += player.dx;
				player.y -= player.dy;
				// transiciones	
				if (entrada->salto) player.estadoActual = FALLING;
				switch (entrada->movimiento) { 
					case reposo: 
						if (entrada->salto) player.estadoActual = F_RIGHT;
						break;
					case arribaDerecha:
					case abajoDerecha:
					case derecha:
						if (entrada->salto) player.estadoActual = F_RIGHT;
						break;
					case arribaIzquierda:
					case abajoIzquierda:
					case izquierda:
						if (entrada->salto) player.estadoActual = F_LEFT;
						break;
					case arriba:
						player.estadoActual = J_HIGH;
						break;
				}
			} else player.estadoActual = FALLING; // transiciones
			break;
		case FALLING:
			if (!player.grounded) {
				// salidas del estado
				player.spriteActual = cayendo;
				if (entrada->salto) {
					// desaceleración del descenso de Jack
					player.spriteActual = reposo;
					player.cuentaSalto++;
					if (player.cuentaSalto == UCHAR_MAX) player.cuentaSalto = 0;
					if (player.cuentaSalto % 2 != 0) break;
				}
				player.y += player.dy;
				// transiciones
				switch (entrada->movimiento) {
					case derecha:
					case arribaDerecha:
					case abajoDerecha:					
						player.estadoActual = F_RIGHT;
						break;
					case izquierda:					
					case arribaIzquierda:
					case abajoIzquierda:
						player.estadoActual = F_LEFT;
						break;
					case abajo:
						player.y++;
						break;
				}				
			} else player.estadoActual = IDLE; // transiciones
			break;
		case F_LEFT: 
			if (!player.grounded) {
				// salidas del estado
				player.spriteActual = caerIzq;
				if (entrada->salto) {
					// desaceleración del descenso de Jack
					player.cuentaSalto++;
					if (player.cuentaSalto == UCHAR_MAX) player.cuentaSalto = 0;
					if (player.cuentaSalto % 2 != 0) break;
				}								
				// comprobación límite izquierdo
				if (!player.leftBounded) player.x -= player.dx;
				player.y += player.dy;
				// transiciones
				switch (entrada->movimiento) {
					case abajo:
						player.estadoActual = FALLING;
						break;
					case abajoIzquierda:
						if (player.y<SCREEN_HEIGHT-16) player.y++;
						break;
					case derecha:
					case arribaDerecha:
					case abajoDerecha:					
						player.estadoActual = F_RIGHT;
						break;
				}
			} else player.estadoActual = IDLE; // transiciones
			break;
		case F_RIGHT: 
			if (!player.grounded) {
				// salidas del estado
				player.spriteActual = caerDer;
				if (entrada->salto) {
					// desaceleración del descenso de Jack
					player.cuentaSalto++;
					if (player.cuentaSalto == UCHAR_MAX) player.cuentaSalto = 0;
					if (player.cuentaSalto % 2 != 0) break;
				}
				// comprobación límite derecho				
				if (!player.rightBounded) player.x += player.dx;
				player.y += player.dy;
				// transiciones
				switch (entrada->movimiento) {
					case abajo:
						player.estadoActual = FALLING;
						break;
					case abajoDerecha:
						if (player.y<SCREEN_HEIGHT-16) player.y++;
						break;
					case izquierda:
					case arribaIzquierda:
						player.estadoActual = F_LEFT;
						break;
				}
			} else player.estadoActual = IDLE; // transiciones
			break;
	} // fin máquina estados

	//--- Actualización de la matriz lógica y de colisones
	// restaurando  en la matriz de colisiones Mundo
	// el valor previo a ser ocupada por el avatar
	Mundo[player.columna][player.fila] = player.x1;
	Mundo[player.columna][player.fila+1] = player.y1;
	Mundo[player.columna+1][player.fila] = player.x2;
	Mundo[player.columna+1][player.fila+1] = player.y2;

	// actualización de la nueva posición del avatar
	player.fila = player.y/TAM_celda_Mundo;
	player.columna = player.x/TAM_celda_Mundo;

	// almacenamiento de la posición actual para restauración posterior y colisiones
	player.x1 = Mundo[player.columna][player.fila];
	player.x2 = Mundo[player.columna+1][player.fila];
	player.y1 = Mundo[player.columna][player.fila+1];
	player.y2 = Mundo[player.columna+1][player.fila+1];
	// actualización en la matriz de colisiones Mundo
	// de la nueva posición del avatar	
	Mundo[player.columna][player.fila] = PLAYER;
	Mundo[player.columna][player.fila+1] = PLAYER;
	Mundo[player.columna+1][player.fila] = PLAYER;
	Mundo[player.columna+1][player.fila+1] = PLAYER;

}

//---- Pinta el avatar Jack en pantalla --------------
void dibujaAvatar(byte plano, byte patron, byte x, byte y) {
	PutSprite (plano,patron,x,y,azul_celeste);		// cabeza, manos, cinturón y pies
	PutSprite (plano+1,patron+4,x,y,blanco);		// ojos y capa
	PutSprite (plano+2,patron+8,x,y,rojo_claro);	// cuerpo
}

//------ Baile Jack consecución de nivel ---------------
void baileFinNivel (void) {
	
	byte i;

	for (i=0; i<2; i++) {
		dibujaAvatar(0, reposo, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, andarIzqQuieto, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, andarIzqMov, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, reposo, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, andarDerQuieto, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, andarDerMov, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, reposo, player.x, player.y);		
		FT_wait(10);
		dibujaAvatar(0, saltar, player.x, player.y);
		FT_wait(10);
		dibujaAvatar(0, reposo, player.x, player.y);
	}
}

//------------------ GUI ------------------------------------------//

//------- Muestra en la pantalla la información de la interfaz gráfica -----
void mostrarGUI (unsigned int PlScore, byte vidas) {
	
	byte fila, columna, tile = 0;
	char texto[9];
	
	// Hi-Score
	sprintf(texto, "%u", gui.HiScore);
	StrConcat(texto,"00");	
	columna = 32-StrLen(texto);
	for (fila=0; fila<StrLen(texto); fila++) {
		switch (texto[fila]) {
			case '0': tablaNombres[(32*2)+columna] = 88; break;
			case '1': tablaNombres[(32*2)+columna] = 89; break;
			case '2': tablaNombres[(32*2)+columna] = 90; break;
			case '3': tablaNombres[(32*2)+columna] = 91; break;
			case '4': tablaNombres[(32*2)+columna] = 92; break;
			case '5': tablaNombres[(32*2)+columna] = 93; break;
			case '6': tablaNombres[(32*2)+columna] = 94; break;
			case '7': tablaNombres[(32*2)+columna] = 95; break;
			case '8': tablaNombres[(32*2)+columna] = 120; break;
			case '9': tablaNombres[(32*2)+columna] = 121; break;
		}
		columna++;
	}

	// multiplicador
	switch (gui.multiplicador) {
		case 1: tile = 89; break;
		case 2: tile = 90; break;
		case 3: tile = 91; break;
		case 4: tile = 92; break;
		case 5: tile = 93; break;
		default: tile = 93;
	}
	tablaNombres[(32*5)+28] = tile;

	// barra de energia
	switch ((byte) gui.barraEnergia) {
		case 0: 
			for (fila=4; fila<7; fila +=2)
				// barra superior e inferior
				for (columna=24; columna<32; columna++) {
					tablaNombres[(32*fila)+columna] = 255;	
				}
			// barra interior
			tablaNombres[(32*5)+24] = 255;
			tablaNombres[(32*5)+25] = 255;
			tablaNombres[(32*5)+30] = 255;
			tablaNombres[(32*5)+31] = 255;
			break;
		case 1:			
			// barra superior
			tablaNombres[(32*4)+27] = 250;
			tablaNombres[(32*4)+28] = 250;
			// barra inferior
			tablaNombres[(32*6)+27] = 251;
			tablaNombres[(32*6)+28] = 251;
			break;
		case 2: 
			// barra superior
			tablaNombres[(32*4)+26] = 250;
			tablaNombres[(32*4)+29] = 250;
			// barra inferior
			tablaNombres[(32*6)+26] = 251;
			tablaNombres[(32*6)+29] = 251;
			break;
		case 3: 
			// barra superior
			tablaNombres[(32*4)+25] = 249;
			tablaNombres[(32*4)+30] = 252;
			// barra interior
			tablaNombres[(32*5)+25] = 249;
			tablaNombres[(32*5)+30] = 252;
			// barra inferior
			tablaNombres[(32*6)+25] = 249;
			tablaNombres[(32*6)+30] = 252;	
			break;
		case 4: 
			// barra superior
			tablaNombres[(32*4)+24] = 248;
			tablaNombres[(32*4)+31] = 253;
			// barra interior
			tablaNombres[(32*5)+24] = 248;
			tablaNombres[(32*5)+31] = 253;
			// barra inferior
			tablaNombres[(32*6)+24] = 248;
			tablaNombres[(32*6)+31] = 253;	
			break;
	}

	// Player Score
	sprintf(texto, "%u", PlScore);
	if (PlScore>0) StrConcat(texto,"00");	
	columna = 32-StrLen(texto);
	for (fila=0; fila<StrLen(texto); fila++) {
		switch (texto[fila]) {
			case '0': tablaNombres[(32*10)+columna] = 88; break;
			case '1': tablaNombres[(32*10)+columna] = 89; break;
			case '2': tablaNombres[(32*10)+columna] = 90; break;
			case '3': tablaNombres[(32*10)+columna] = 91; break;
			case '4': tablaNombres[(32*10)+columna] = 92; break;
			case '5': tablaNombres[(32*10)+columna] = 93; break;
			case '6': tablaNombres[(32*10)+columna] = 94; break;
			case '7': tablaNombres[(32*10)+columna] = 95; break;
			case '8': tablaNombres[(32*10)+columna] = 120; break;
			case '9': tablaNombres[(32*10)+columna] = 121; break;
		}
		columna++;
	}

	// Nº de vidas
	switch (vidas) { // número máximo de vidas = 9
		case 0: tile = 88; break;
		case 1: tile = 89; break;
		case 2: tile = 90; break;
		case 3: tile = 91; break;
		case 4: tile = 92; break;
		case 5: tile = 93; break;
		case 6: tile = 94; break;
		case 7: tile = 95; break;
		case 8: tile = 120; break;
		case 9: tile = 121; break;
	}
	tablaNombres[(32*14)+29] = tile;

	// Nivel
	switch ((gui.nivel+1)%10) {	// unidades
		case 0: tile = 88; break;
		case 1: tile = 89; break;
		case 2: tile = 90; break;
		case 3: tile = 91; break;
		case 4: tile = 92; break;
		case 5: tile = 93; break;
		case 6: tile = 94; break;
		case 7: tile = 95; break;
		case 8: tile = 120; break;
		case 9: tile = 121; break;
	}
	tablaNombres[(32*19)+28] = tile; 

	switch ((gui.nivel+1)/10) {	// decenas
		case 0: tile = 88; break;
		case 1: tile = 89; break;
		case 2: tile = 90; break;
		case 3: tile = 91; break;
		case 4: tile = 92; break;
		case 5: tile = 93; break;
		case 6: tile = 94; break;
	}
	tablaNombres[(32*19)+27] = tile;

}

//------------------ LETREROS INICIO Y FIN (START Y GAME OVER) -----------------------------------

//----- Muestra el letrero de START! y reproduce el FX de inicio de partida -----
void mostrarStart(void) {
	
	char buffer_start_superior[8], buffer_start_inferior[8];
	byte columna = 0, i;

	// Inicializando buffer_start_superior con los tiles a mostrar de START!
	for (i=223; i>215; i--) {
		buffer_start_superior[columna] = i;
		columna++;
	}
	// Inicializando buffer_start_inferior con los tiles a mostrar de START!
	columna=0;
	for (i=247; i<255; i++) {
		buffer_start_inferior[columna] = i;
		columna++;
	}
	// Mostrando letreo 'START!'
	for (columna=9; columna<16; columna++) {
		Vpoke(dirBaseTablaNombres+(32*10)+columna, buffer_start_superior[16-columna]);
		Vpoke(dirBaseTablaNombres+(32*11)+(24-columna), buffer_start_inferior[16-columna]);
		FT_wait(4);
	}

	FT_wait(90);

	// Restaurando la tabla de nombres en la VRAM
	CopyRamToVram (&tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);

}

//-------- Muestra letrero de GAME OVER ---------
void mostrarLetreroGameOver (void) {

	byte j;			// columna de la pantalla
	byte tile = 15;	// patrón de las letras donde empieza el GAME OVER

	for (j=8; j<17; j++)
		// omitmos el tile del espacio que separa las palabras GAME OVER
		if (j!=12) {
			tablaNombres[(32*11)+j] = tile;	
			tile++;
		} else tile = 47;

	CopyRamToVram (&tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);
}

//------------------- BONUS --------------------------------------------/

//------- Mostrar pantalla de Bonus ------------ 
unsigned int bonus(byte nBombas, unsigned int PL_score, byte nivel_actual) {
	
	unsigned char i, j;
	int bonus = 0;
	char texto[9];
	byte color = 0x51;
	
	CopyVramToRam (dirBaseTablaNombres, buffer_tablaNombres, TAM_TablaNombres);

	// Calculando los puntos de 'Special Bonus'
	switch (nBombas) {
		case 20: bonus = 100; break;
		case 21: bonus = 200; break;
		case 22: bonus = 300; break;
		case 23: bonus = 500; break;
	}

	// Pintando el nivel
	sprintf(texto, "%d", nivel_actual);
	for (i=0; i<StrLen(texto); i++) 
		buffer_tablaNombres[(32)+27-StrLen(texto)+i] = texto[i];

	// Pintando el numero de bombas encenidadas capturadas
	sprintf(texto, "%d", nBombas);
	for (i=0; i<StrLen(texto); i++) 
		buffer_tablaNombres[(32*11)+11-StrLen(texto)+i] = texto[i];
	// color del numero de bombas (Banco 1 VRAM)
	for (i=0; i<StrLen(texto); i++)
		for (j=0; j<8; j++)
			Vpoke (dirBaseTablaColor+0x800+(texto[i]*8)+j, color);

	// Pintando los puntos de 'Special Bonus' (Banco 2 VRAM)
	sprintf(texto, "%d", bonus);
	for (i=0; i<StrLen(texto); i++) 
		buffer_tablaNombres[(32*17)+15-StrLen(texto)+i] = texto[i];
	// Coloreando puntos de bonus especiales
	StrConcat(texto,"Pts");
	for (i=0; i<StrLen(texto); i++)		
		for (j=0; j<8; j++)
			Vpoke (dirBaseTablaColor+0x1000+(texto[i]*8)+j, color);	

	do {		
		// Pintando el PL-Score
		sprintf(texto, "%u", PL_score);
		StrConcat(texto,"00");	
		for (i=0; i<StrLen(texto); i++) 
			buffer_tablaNombres[(32)+9-StrLen(texto)+i] = texto[i];
		if (PL_score<UINT_MAX) PL_score++;
		bonus--;	

		// Restaurando en VRAM la tabla de nombres del salon de la fama (buffer)
		CopyRamToVram (&buffer_tablaNombres[0], dirBaseTablaNombres, TAM_TablaNombres);
		
	} while (bonus>=0);

	return PL_score-1;
}

//----------------------------- LOGICA -----------------------------/

//------ Lectura de los controles de entrada (cursores -> 0, Joystick 1 -> 1, Joystick 2 -> 2) -----
char procesarEntrada (t_Entrada *entrada) {
	
	char joy1, joy2, fire1, fire2;

	// dispositivo de entrada por defecto -> cursores teclado
	entrada->movimiento = JoystickRead(0);
	entrada->salto = TriggerRead(0);

	// comprobación de uso de palancas de juego
	joy1 = JoystickRead(1);
	fire1 = TriggerRead(1);
	joy2 = JoystickRead(2);
	fire2 = TriggerRead(2);
	
	if (joy1 || fire1) { 
		entrada->movimiento = joy1;
		entrada->salto = fire1;
	} else if (joy2 || fire2) {
		entrada->movimiento = joy2;
		entrada->salto = fire2;
	}

	return Inkey();
}

//------ actualización de colisiones con bombas, enemigos y monedas -------
boolean actualizaColisiones (void) {

//	Se recorren las listas de bombas, monedas y de enemigos, si alguno comparte 
//	coordenadas fila y columna con el avatar, es porque existe colisión

	char item, i;

	// detección de colisón con alguna bomba
	for (item=0; item<MAX_BOMBAS; item++)
		if (!lista_bombas[item].recogida)
			if ((lista_bombas[item].x == player.fila || lista_bombas[item].x == player.fila+1) && 
				(lista_bombas[item].y == player.columna || lista_bombas[item].y == player.columna+1)) {
				// existe colisón con una bomba
				player.bombas++;
				gui.scoreLevel += recogeBomba(&lista_bombas[item]);
				// actualizamos la bomba a encender
				while (lista_bombas[nextBomba].recogida) nextBomba++;
				// Se recoge una bomba encendida-> se enciende otra					
				enciendeBomba(&lista_bombas[nextBomba]);
				PlayFX(8);
				pintafondo = true;
				break;	// se aborta la búsqueda de colisión con una bomba
			}
	
	// detección de colisión con alguna moneda
	if (nMonedas>0)
		for (item=0; item<MAX_MONEDAS; item++) 
			if (listaMonedas[item].activa == true)
				// comprobación de si exite colisión con el avatar
				if ((listaMonedas[item].fila == player.fila || listaMonedas[item].fila == player.fila+1) && 
						(listaMonedas[item].columna == player.columna || listaMonedas[item].columna == player.columna+1)) {
						// existe colisón con una moneda
						listaMonedas[item].activa = false;
						listaMonedas[item].y = 209; 		// ocultación del sprite en pantalla
						listaMonedas[item].x = -32; 		// ocultación del sprite en pantalla
						PutSprite (listaMonedas[item].plano, listaMonedas[item].spriteActual, listaMonedas[item].x,listaMonedas[item].y, listaMonedas[item].color);
						// actualización de la puntuación según tipo de moneda
						switch (listaMonedas[item].tipo) { // B,E,S,P
							case B:
								gui.scoreLevel += 10;
								gui.multiplicador++;
								break;
							case E:
								gui.scoreLevel += 30;
								if (player.vidas < 9) player.vidas++;	// nº max. vidas = 9
								player.enemigos = 0;
								break;
							case S:
								gui.scoreLevel += 50;
								player.bombas = MAX_BOMBAS; // se avanza al siguiente nivel
								break;	
							case P:	// dependiendo su color, varía su puntuación
								switch (listaMonedas[item].color) {
									case azul_celeste:
										gui.scoreLevel += 1;
										break;
									case rojo_claro:
										gui.scoreLevel += 2;
										break;
									case magenta:
										gui.scoreLevel += 3;
										break;
									case verde_claro:
										gui.scoreLevel += 5;
										break;
									case azul_claro:
										gui.scoreLevel += 8;
										break;
									case amarillo_claro:
										gui.scoreLevel += 12;
										break;
									case gris:
										gui.scoreLevel += 20;
										break;
								}
								gui.barraEnergia = 0;
								// cambiar enemigos a moneda ORO
								for (i=0; i<nEnemigos; i++) {
									listaEnemigos[i].estadoActual = MONEDA;
									listaEnemigos[i].temporizador = RealTimer();
									// Activación bandera-contador estado MONEDA ORO
									nMonedasORO++;
								}								
								break;						
						}	// switch (tipo moneda)
						nMonedas--;						
						pintafondo = true;
						break;	// no hace falta buscar más pues ya se ha encontrado
				} // fin if

	// detección de colisón con algún enemigo
	if (player.vidas>0 && nEnemigos>0)
		for (item=0; item<nEnemigos; item++)
			if ((listaEnemigos[item].fila == player.fila || listaEnemigos[item].fila == player.fila+1) && 
				(listaEnemigos[item].columna == player.columna || listaEnemigos[item].columna == player.columna+1)) {
					if (!player.inmunidad && listaEnemigos[item].estadoActual == ALIVE) {
						// existe colisón con un enemigo
						player.spriteActual = muerto;
						dibujaAvatar(0, player.spriteActual, player.x, player.y);
						// reproducción FX muerte
						PlayFX(5);
						SincronizaFX (90);
						player.vidas--;
						// inicializando avatar
						player.x = SCREEN_WIDTH/2;
						player.y = SCREEN_HEIGHT/2;
						player.spriteActual = player.spriteInicio;
						player.grounded = player.ceiling = false;
						player.estadoActual = IDLE;
						player.fila = player.y/TAM_celda_Mundo;
						player.columna = player.x/TAM_celda_Mundo;				
						dibujaAvatar(0, player.spriteActual, player.x, player.y);
						// animación letrero 'START!'
						if (player.vidas>0) mostrarStart();
						pintafondo = true;
						break;	// se aborta la búsqueda de colisión con una bomba
					}
					if (listaEnemigos[item].estadoActual == MONEDA) {
						listaEnemigos[item].estadoActual = DEAD;
						listaEnemigos[item].y = 209; // ocultación del sprite en pantalla
						listaEnemigos[item].x = -32;
						// PutSprite
						PutSprite (listaEnemigos[item].plano, listaEnemigos[item].spriteActual,listaEnemigos[item].x,listaEnemigos[item].y, negro);
						nEnemigos--;
						nMonedasORO--;
						player.enemigos++;
						reordenarListaEnemigos =  true;
						switch (player.enemigos) {
							case 1: if (player.PlScore+1 < UINT_MAX) player.PlScore++;		break;
							case 2: if (player.PlScore+2 < UINT_MAX) player.PlScore += 2;	break;
							case 3: if (player.PlScore+3 < UINT_MAX) player.PlScore += 3;	break;
							case 4: if (player.PlScore+5 < UINT_MAX) player.PlScore += 5;	break;
							case 5: if (player.PlScore+8 < UINT_MAX) player.PlScore += 8;	break;
							case 6: if (player.PlScore+12 < UINT_MAX) player.PlScore += 12;	break;
							default: if (player.PlScore+20 < UINT_MAX) player.PlScore += 20;
						}					
					}
					pintafondo = true;					
					break;
			}
	// retornar si se produce Game Over
	return (player.vidas <= 0);

}

//----------- Wait some times ------------------
char FT_wait(int cicles)
{
  int i;
  for(i=0;i<cicles;i++) 
  {
    EnableInterrupt();
    Halt();
  }
  return(0);
}

//--- generación de números aleatorios dentro de un intervalo definido ---
char FT_RandomNumber (char a, char b)
{
    char random;
    
    random = rand()%(b-a)+a;  // Random number between a and b-1
    return (random);
}

/* ---------------------------------
            FT_errorHandler

          In case of Error
-----------------------------------*/ 
void FT_errorHandler(char n, char *name)
{
  InitPSG();
  Screen(0);
  SetColors(15,6,6);
  switch (n)
  {
      case 1:
          printf("\n\rFAILED: fcb_open(): %s ",name);
      break;

      case 2:
          printf("\n\rFAILED: fcb_close(): %s",name);
      break;  

      case 3:
          printf("\n\rSORRY: this game does not work on %s",name);
      break; 
  }
Exit(0);
}

/* ---------------------------------
                FT_SetName

    Set the name of a file to load
                (MSX DOS)
-----------------------------------*/ 
void FT_SetName( FCB *p_fcb, const char *p_name ) {
  char i, j;
  memset( p_fcb, 0, sizeof(FCB) );
  for( i = 0; i < 11; i++ ) {
    p_fcb->name[i] = ' ';
  }
  for( i = 0; (i < 8) && (p_name[i] != 0) && (p_name[i] != '.'); i++ ) {
    p_fcb->name[i] =  p_name[i];
  }
  if( p_name[i] == '.' ) {
    i++;
    for( j = 0; (j < 3) && (p_name[i + j] != 0) && (p_name[i + j] != '.'); j++ ) {
      p_fcb->ext[j] =  p_name[i + j] ;
    }
  }
}

//------------------- FX -------------------------------//

/* ---------------------------------
          FT_LoadData
  Load Data to a specific pointer
  size is the size of data to read
  skip represent the number of Bytes
  you want to skip from the begining of the file
  Example: skip=7 to skip 7 bytes of a MSX bin
-----------------------------------*/ 
int FT_LoadData(char *file_name, char *buffer, int size, int skip)
{
    
    FT_SetName( &file, file_name );
    if(fcb_open( &file ) != FCB_SUCCESS) 
    {
          FT_errorHandler(1, file_name);
          return (0);
    }
    if (skip>0)
    {
        fcb_read( &file, buffer, skip );
    }
   
    
    fcb_read( &file, buffer, size );
    
    if( fcb_close( &file ) != FCB_SUCCESS ) 
    {
      FT_errorHandler(2, file_name);
      return (0);
    }
    return(0);
}

/* ---------------------------------
            FT_CheckFX
     Check if Playing Sound FX
          must be updated
-----------------------------------*/
void FT_CheckFX (void)
{ 
 if (TestFX()==1)
 {
      if (JIFFY!=0)
      {
       JIFFY=0;
        UpdateFX();
      }
  }
}

//----- Sincroniza el tiempo de FX ------
void SincronizaFX (char temp) {

	char i;

	for (i=0; i<temp; i++) {
		FT_wait(1);
		FT_CheckFX();  
	}
}					     

//-------------------- SALIR -----------------------------//

//---- Vuelta al MSX-DOS ----
void salirMSXDOS (void) {
	
	InitPSG();
	KillKeyBuffer();
	Screen(0);
	SetColors(15, 4, 4);
	Exit (0);
}







   
